'use client';

import { motion } from 'framer-motion';
import Image from 'next/image';

export default function CoupleIntro() {
    return (
        <div className="container md:max-w-[1200px] mx-auto px-4 py-20 md:h-[80vh]">
            <div className="grid grid-cols-1 md:grid-cols-3 justify-center h-full gap-8">
                {/* Left side - Bride */}
                <motion.div
                    initial={{ opacity: 0, x: -20 }}
                    whileInView={{ opacity: 1, x: 0 }}
                    transition={{ duration: 0.8 }}
                    className="space-y-1 text-center md:text-left"
                >
                    <h2 className="text-coral font-script text-4xl md:text-5xl">
                        Adaeze Danielle
                    </h2>
                    <p className="font-light text-[1.25rem] leading-8">
                        I am Adaeze Danielle Ogochukwu, a cool bride brimming with immense joy as I finally get to be with my person in our leap of faith to forever.
                    </p>
                </motion.div>

                <div className="flex justify-center items-center mb-4 md:mb-[-100px] relative w-full max-w-[300px] mx-auto md:max-w-[340px] h-auto">
                    <div className="h-[580px] w-full static md:absolute inset-0">
                        <Image src="/couple-mainn.jpg" fill alt="Couple Main Image" className="rounded-full object-cover object-top w-full h-full" />
                    </div>
                </div>

                {/* Right side - Groom */}
                <motion.div
                    initial={{ opacity: 0, x: 20 }}
                    whileInView={{ opacity: 1, x: 0 }}
                    transition={{ duration: 0.8 }}
                    className="flex flex-col justify-end h-full space-y-1 text-center md:text-left"
                >
                    <h2 className="text-coral font-script text-4xl md:text-5xl">
                        Bolaji Junaid
                    </h2>
                    <p className="font-light text-[1.25rem] leading-8">
                        I am Bolaji Junaid, a storyteller and a man finished by the finished works of Christ and Ada Ada.
                    </p>
                </motion.div>
            </div>
        </div>
    );
} 