'use client';

import { motion } from 'framer-motion';
import { useState } from 'react';
import Image from 'next/image';
import dynamic from 'next/dynamic';

const GiftModalWithoutSSR = dynamic(
    () => import('./GiftModal'),
    { ssr: false }
)

export default function Gifts() {
    const [isModalOpen, setIsModalOpen] = useState(false);

    const VENDOR_LOGOS = [
        "/vendors/0.png",
        "/vendors/1.png",
        "/vendors/2.png",
        "/vendors/3.png",
        "/vendors/4.png",
        "/vendors/5.png",
        "/vendors/6.png",
        "/vendors/7.png",
        "/vendors/8.png",
        "/vendors/9.png",
        "/vendors/10.png",

    ]

    return (
        <div className="container mx-auto px-4 py-20">
            <motion.div
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                transition={{ duration: 0.8 }}
                className="max-w-2xl mx-auto text-center space-y-8"
            >
                <h2 className="text-coral font-script text-4xl md:text-5xl">Gifts</h2>

                <p className="font-light text-[1.25rem] leading-8">
                    Your prayers and you being part of our big day is already a gift to us, however if you would like to gift us, we would appreciate ALL is converted to cash.
                </p>

                <button
                    className="btn-solid text-sm"
                    onClick={() => setIsModalOpen(true)}
                >
                    BE A PART OF OUR JOURNEY
                </button>
            </motion.div>

            <GiftModalWithoutSSR
                isOpen={isModalOpen}
                onClose={() => setIsModalOpen(false)}
            />

            <div className="container mx-auto px-4 py-20 pt-40">
                <motion.div
                    initial={{ opacity: 0, y: 20 }}
                    whileInView={{ opacity: 1, y: 0 }}
                    transition={{ duration: 0.8 }}
                    className="max-w-6xl mx-auto text-center space-y-12"
                >
                    <h2 className="text-coral font-script text-2xl md:text-4xl">Collaborating Brands</h2>

                    <div className="max-w-[300px] md:max-w-[1200px] mx-auto flex flex-wrap gap-4 md:gap-8 items-center justify-center">
                        {VENDOR_LOGOS.map((logo, index) => (
                            <motion.div
                                key={index}
                                initial={{ opacity: 0, scale: 0.9 }}
                                whileInView={{ opacity: 1, scale: 1 }}
                                transition={{ duration: 0.5, delay: index * 0.1 }}
                                className="basis-[calc(50%-8px)] md:basis-[calc(16.666%-40px)] h-[60px] md:h-[80px] relative"
                            >
                                <Image
                                    src={logo}
                                    alt={`Vendor ${index}`}
                                    fill
                                    className="object-contain"
                                />
                            </motion.div>
                        ))}
                    </div>
                </motion.div>
            </div>
        </div>
    );
} 