'use client';

import { motion } from 'framer-motion';
import Image from 'next/image';
import { useRouter } from 'next/navigation';

export default function OurStories() {
    const router = useRouter();

    return (
        <div className="container md:max-w-[1200px] mx-auto px-4 py-20">
            {/* His Story */}
            <div className="grid grid-cols-1 md:grid-cols-[340px_1fr] items-center max-w-[1000px] mx-auto gap-12 mb-20">
                <motion.div
                    initial={{ opacity: 0, x: -20 }}
                    whileInView={{ opacity: 1, x: 0 }}
                    transition={{ duration: 0.8 }}
                    className="w-full md:w-[340px] flex justify-end"
                >
                    <div className="relative w-[85%] max-w-[340px] mx-auto md:w-full h-[520px] rounded-full">
                        {/* Decorative leaves - left */}
                        <div className="absolute -left-[90px] -top-[90px] -z-10">
                            <Image
                                src="/leaves.png"
                                alt="Decorative leaves"
                                width={340}
                                height={80}
                            />
                        </div>
                        <Image
                            src="/groom.jpg"
                            alt="Groom's photo"
                            fill
                            className="object-cover rounded-full -scale-x-100"
                            layout="fill"
                            objectFit="cover"
                        />
                    </div>
                </motion.div>

                <motion.div
                    initial={{ opacity: 0, x: 20 }}
                    whileInView={{ opacity: 1, x: 0 }}
                    transition={{ duration: 0.8 }}
                    className="text-center md:text-left"
                >
                    <h2 className="text-coral font-script text-4xl md:text-5xl">His Story</h2>
                    <p className="font-light text-[1.25rem] leading-8">
                        Who is this petite, yellow-looking girl in high heels, and what makes
                        her so different from the rest of us here? This was my first impression
                        of Adaeze back in 2014, at Church 3:16, the youth fellowship of The
                        Fountain of Life Church. She always arrived with an entourage of
                        friends, many of whom I already knew, but she stood out in a way that
                        piqued my curiosity.
                    </p>
                    <button className="btn-outline-dark text-sm mt-6" onClick={() => router.push('/how-we-met/his-story')}>READ MORE</button>
                </motion.div>
            </div>

            {/* Her Story */}
            <div className="grid grid-cols-1 md:grid-cols-[1fr_340px] max-w-[1000px] mx-auto items-center gap-12">
                <motion.div
                    initial={{ opacity: 0, x: -20 }}
                    whileInView={{ opacity: 1, x: 0 }}
                    transition={{ duration: 0.8 }}
                    className="text-center md:text-left"
                >
                    <h2 className="text-coral font-script text-4xl md:text-5xl">Her Story</h2>
                    <p className="text-[1.25rem] leading-8">
                        It all began on November 2, 2019. A close friend invited me to
                        Johnny Drille&apos;s second concert in Lagos, held at Muri Okunola Park.
                        Being a big fan of Johnny&apos;s music and style, I couldn&apos;t pass up the
                        chance to attend. Little did I know that the evening would begin a
                        journey that would change my life forever.
                    </p>
                    <button className="btn-outline-dark text-sm mt-6" onClick={() => router.push('/how-we-met/her-story')}>READ MORE</button>
                </motion.div>

                <motion.div
                    initial={{ opacity: 0, x: 20 }}
                    whileInView={{ opacity: 1, x: 0 }}
                    transition={{ duration: 0.8 }}
                    className="order-first md:order-last md:w-[340px]"
                >
                    <div className="relative w-[85%] max-w-[340px] mx-auto md:w-full h-[520px] rounded-full ">
                        {/* Decorative leaves - left */}
                        <div className="absolute -right-[140px] -top-[70px] -z-10 scale-y-[-1] scale-x-[-1] rotate-[58deg]">
                            <Image
                                src="/leaves.png"
                                alt="Decorative leaves"
                                width={340}
                                height={80}
                            />
                        </div>
                        <Image
                            src="/bride.jpg"
                            alt="Bride's photo"
                            fill
                            className="object-cover rounded-full -scale-x-100"
                        />
                    </div>
                </motion.div>
            </div>
        </div>
    );
} 