'use client';

import { motion } from 'framer-motion';
import BlogPost, { BlogPostProps } from './BlogPost';

interface RecentBlogSectionProps {
    blogPosts: BlogPostProps[];
    title?: string;
    loadMore?: boolean;
    isLoadingMore?: boolean;
    limit?: number;
    loadMoreButton?: () => void;
}

export default function RecentBlogSection({ blogPosts, title = "Recent Blog Posts", loadMore = true, loadMoreButton, limit = 12, isLoadingMore = false }: RecentBlogSectionProps) {
    return (
        <section className="py-16 px-4 md:px-8">
            <motion.h2
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                className="text-4xl font-script text-coral mb-8"
            >
                {title}
            </motion.h2>

            <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
                {blogPosts.map((post, index) => {
                    if (index >= limit) {
                        return null;
                    }
                    return <BlogPost key={index} {...post} />
                }
                )}
            </div>

            {loadMore && <div className="flex justify-center mt-12">
                {isLoadingMore ? <button className="btn-outline-dark disabled:opacity-50 disabled:cursor-not-allowed text-sm" disabled>
                    LOADING...
                </button> : <button className="btn-outline-dark text-sm" onClick={loadMoreButton}>
                    LOAD MORE
                </button>}
            </div>}
        </section>
    );
} 