'use client'

import { motion } from 'framer-motion';
import Image from 'next/image';
import Navbar from '../components/Navbar';

const storyPost = {
    title: "Our Engagement Story",
    excerpt: "As we wrapped up one of our countless late-night calls, she chuckled and said, 'Let&apos;s do this, babe.' That was all the confirmation I needed. It was time to step up and do the needful.",
    content: `
        <p>As we wrapped up one of our countless late-night calls, she chuckled and said, “Let’s do this, babe.” That was all the confirmation I needed. It was time to step up and do the needful.</p>

    <p>The next day, I reached out to one of her big sisters, Bolanle, and told her I was ready to propose. I needed her help to pull it off in a way Adaeze would love. Bolanle took it upon herself to do one final check, subtly confirming Adaeze’s readiness. She came back with a green light. I was elated, and slightly nervous.</p>

    <p>The first challenge? Pulling off the proposal without raising her suspicion, especially since she had always mentioned wanting her close friends and family to be present. But is there any challenge a finished man with the finished works of Christ and Ada Ada by his side cannot overcome? Absolutely not.</p>

    <p>I swung into action. First, I reached out to her elder brother and her mum to ask for their blessings. When Mum gave her heartfelt prayers of acceptance, I knew I had chosen right.</p>

    <p>Now, the real challenge, getting Adaeze to Nigeria, gathering all her friends in one place, and asking her to build a home with me. Then, a light bulb moment: Mum’s 60th birthday!</p>

    <blockquote>
      <p>“Ada Ada, it would be great if you could surprise Mum for her 60th birthday. It’s such a milestone, you wouldn’t want to miss it.” That was my pitch as we ended our conversation that night. When she called the next day to say she’d bought her ticket and would be arriving a week before the birthday, my joy knew no bounds.</p>
    </blockquote>

    <p>With that settled, the proposal plans went into full gear. Bolanle and I reviewed three potential venues before deciding on The Wine Lab, a perfect spot that matched Adaeze’s love for fine dining. Then came the search for the perfect ring, one she had innocently admired during one of our window-shopping rounds in Doha. Her sisters, Adesuwa and Victoria, were instrumental in getting the right size and making the final selection.</p>

    <p>What we didn’t anticipate was the sudden misplacement of a vital travel document. Everything stood still. We tried everything to retrieve it before her flight, but nothing worked. To this day, how she made it to Lagos, on a different flight after being stuck at the airport for over twelve hours, remains one of the biggest miracles in our story. It was as though God Himself was orchestrating every detail, thanks to big sis, Bukky who God used yet with no inclination that her baby was about to be proposed to.</p>

    <p>At exactly 8 AM on September 22, 2024, she arrived at MMIA, looking exhausted but managing a smile. We hugged tightly, and in her mind, she was about to surprise her dear mum. What she didn’t know was that Mum already knew about the proposal, she just thought it would be a virtual event, with a watch party set up around Victoria Island, Lagos.</p>

    <p>It was a double surprise.</p>

    <p>The first step was for Adaeze to visit my parents before the big moment. Meanwhile, I had to “attend a client meeting” at Radisson Blu&mdash;at least, that’s what she thought. Bolanle also played her part perfectly, offering to pamper her after such a long and tiring trip. Everything was falling into place, except one thing, her nails!</p>

    <p>I dropped her off at Bolanle’s, pretending to sulk that she was getting pampered without me. Little did she know, it was all a setup. I wanted to pamper her for life. Bolanle and I stayed in sync, and before Adaeze knew it, she was walking into the proposal venue, welcomed with a bouquet from her little niece.</p>

    <p>Then, at exactly 6:27pm Nigerian time, my promise from God said yes to doing life with me, surrounded by our closest friends and family. Many more joined virtually, and the moment she hugged her mum tightly, overwhelmed with joy, was everything I had hoped for.</p>

    <p>It was perfect.</p>
    `,
    image: "/groom.jpg",
    author: "Bolaji J.",
    authorImage: "/groom.jpg",
    date: "14 Feb 2025"
}

export default function OurStoryPage() {

    return (
        <main>
            <Navbar topPlacement={true} />

            <div className="mt-28 container mx-auto px-4 md:max-w-[1200px]">

                {/* Content Container */}
                <div className="px-2 md:px-20">
                    {/* Blog Header */}
                    <motion.div
                        initial={{ opacity: 0, y: 20 }}
                        animate={{ opacity: 1, y: 0 }}
                        className=" mb-12"
                    >
                        <h1 className="text-3xl font-script md:text-4xl mb-2 mt-6">
                            {storyPost.title}
                        </h1>
                        <div className="flex items-center justify-start gap-2 text-sm text-[#222222]/80">
                            <div className="flex items-center gap-2">
                                <Image
                                    src={storyPost.authorImage}
                                    alt={storyPost.author}
                                    width={32}
                                    height={32}
                                    className="rounded-full aspect-square object-cover"
                                />
                                <div className="flex flex-col">
                                    <span>{storyPost.author}</span>
                                    <span className="text-xs">The Storytelling Groom</span>
                                </div>
                            </div>
                            {/* <span>•</span>
                            <span>{storyPost.date}</span> */}
                        </div>
                    </motion.div>

                    {/* Blog Content */}
                    <motion.div
                        initial={{ opacity: 0 }}
                        animate={{ opacity: 1 }}
                        transition={{ delay: 0.2 }}
                        className="prose w-full mb-16"
                        dangerouslySetInnerHTML={{ __html: storyPost.content }}
                    >
                    </motion.div>
                </div>
            </div>
        </main>
    );
}