import type { Metadata } from "next";
import { Lato } from "next/font/google";
import "./globals.css";

const lato = Lato({ subsets: ["latin"], variable: "--font-lato", weight: ["300", "400", "700"] });

export const metadata: Metadata = {
  title: "Adaeze & Bolaji - Wedding Celebration",
  description: "Join us in celebrating our love story - April 25, 2025",
  icons: {
    icon: "/ABC-Logo.png",
  },
};

export default function RootLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return (
    <html lang="en" className="scroll-smooth">
      <body className={`${lato.variable} font-sans`}>
        {children}
      </body>
    </html>
  );
}
