'use client';

import { Suspense } from 'react';
import dynamic from 'next/dynamic'

const SuccessComponentWithNoSSR = dynamic(
    () => import('./SuccessContent'),
    { ssr: false }
)

export default function SuccessPage() {
    return (
        <Suspense
            fallback={
                <div className="min-h-screen flex items-center justify-center">
                    <div className="animate-spin rounded-full h-12 w-12 border-t-2 border-b-2 border-coral"></div>
                </div>
            }
        >
            <SuccessComponentWithNoSSR />
        </Suspense>
    );
}