import Link from 'next/link';
import ArrowRightIcon from './icons/ArrowRightIcon';
import { motion } from 'framer-motion';

const EngagementStory = () => {
    return (
        <div className="container mx-auto px-4 py-16 md:py-24">
            <div className="max-w-6xl mx-auto">
                <motion.h2
                    initial={{ opacity: 0, y: 20 }}
                    whileInView={{ opacity: 1, y: 0 }}
                    transition={{ duration: 0.8 }}
                    className="text-4xl md:text-5xl font-script text-coral text-center mb-8"
                >
                    Our Engagement Story
                </motion.h2>

                <div className="flex flex-col gap-8 items-center">
                    {/* Story Excerpt */}
                    <motion.div
                        initial={{ opacity: 0, y: 20 }}
                        whileInView={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.8, delay: 0.2 }}
                        className="space-y-4"
                    >
                        <p className="font-light text-[1.25rem] leading-8 text-center">
                            As we wrapped up one of our countless late-night calls, she chuckled and said, &quot;Let&apos;s do this, babe.&quot; That was all the confirmation I needed. It was time to step up and do the needful.
                        </p>
                        <Link href={"/engagement-story"} className="inline-block w-full">
                            <button className="p-0 uppercase font-normal hover:text-coral text-sm flex items-center gap-2 justify-center w-full">
                                READ MORE <ArrowRightIcon className="w-6 h-6 ml-2 rounded-full border border-[#454545] " />
                            </button>
                        </Link>
                    </motion.div>

                    {/* Video Section */}
                    <motion.div
                        initial={{ opacity: 0, y: 20 }}
                        whileInView={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.8, delay: 0.4 }}
                        className="aspect-video w-full"
                    >
                        <iframe
                            className="w-full h-full rounded-lg shadow-lg"
                            src="https://www.youtube-nocookie.com/embed/kvQx79P2jPw?rel=0"
                            title="Adaeze x Bolaji Engagement Video"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                            referrerPolicy="strict-origin-when-cross-origin"
                            allowFullScreen
                        ></iframe>

                    </motion.div>
                </div>
            </div>
        </div>
    );
};

export default EngagementStory; 