'use client';

import { motion } from 'framer-motion';
import Image from 'next/image';

const row1Images = [
    {
        src: "/gallery/1.jpg",
        alt: "Couple romantic moment",
    },
    {
        src: "/gallery/2.jpg",
        alt: "Couple sitting together",
    },
    {
        src: "/gallery/3.jpg",
        alt: "Bride smiling",
    },
    // Duplicate images for seamless loop
    {
        src: "/gallery/4.jpg",
        alt: "Couple romantic moment",
    },
    {
        src: "/gallery/5.jpg",
        alt: "Couple sitting together",
    },
    {
        src: "/gallery/6.jpg",
        alt: "Bride smiling",
    },
    // Additional duplicates
    {
        src: "/gallery/7.jpg",
        alt: "Couple romantic moment",
    },
    {
        src: "/gallery/8.jpg",
        alt: "Couple sitting together",
    },
];

const row2Images = [
    {
        src: "/gallery/6.jpg",
        alt: "Couple embracing",
    },
    {
        src: "/gallery/7.jpg",
        alt: "Couple portrait",
    },
    {
        src: "/gallery/8.jpg",
        alt: "Bride with flowers",
    },
    // Duplicate images for seamless loop
    {
        src: "/gallery/9.jpg",
        alt: "Couple embracing",
    },
    {
        src: "/gallery/10.jpg",
        alt: "Couple portrait",
    },
    {
        src: "/gallery/6.jpg",
        alt: "Bride with flowers",
    },
    // Additional duplicates
    {
        src: "/gallery/7.jpg",
        alt: "Couple embracing",
    },
    {
        src: "/gallery/8.jpg",
        alt: "Couple portrait",
    },
];

export default function Gallery() {
    // Calculate the total width of images (300px width + 16px gap) * number of unique images
    const moveAmount = (300 + 16) * 3;

    return (
        <section id="gallery" className="py-20 overflow-hidden bg-[#F7F7F7]">
            <motion.div
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                transition={{ duration: 0.8 }}
                className="container mx-auto px-4"
            >
                <h2 className="text-coral font-script text-4xl md:text-5xl text-center mb-12">Gallery</h2>

                <div className="space-y-4">
                    {/* First row - moves right */}
                    <motion.div
                        className="flex gap-4"
                        animate={{
                            x: [0, -moveAmount],
                        }}
                        transition={{
                            x: {
                                repeat: Infinity,
                                repeatType: "loop",
                                duration: 20,
                                ease: "linear",
                            },
                        }}
                    >
                        {row1Images.map((image, index) => (
                            <div
                                key={index}
                                className="relative w-[300px] h-[300px] flex-shrink-0 rounded-lg overflow-hidden"
                            >
                                <Image
                                    src={image.src}
                                    alt={image.alt}
                                    fill
                                    className="object-cover hover:scale-110 transition-transform duration-300"
                                />
                            </div>
                        ))}
                    </motion.div>

                    {/* Second row - moves left */}
                    <motion.div
                        className="flex gap-4"
                        animate={{
                            x: [-moveAmount, 0],
                        }}
                        transition={{
                            x: {
                                repeat: Infinity,
                                repeatType: "loop",
                                duration: 20,
                                ease: "linear",
                            },
                        }}
                    >
                        {row2Images.map((image, index) => (
                            <div
                                key={index}
                                className="relative w-[300px] h-[300px] flex-shrink-0 rounded-lg overflow-hidden"
                            >
                                <Image
                                    src={image.src}
                                    alt={image.alt}
                                    fill
                                    className="object-cover hover:scale-110 transition-transform duration-300"
                                />
                            </div>
                        ))}
                    </motion.div>
                </div>
            </motion.div>
        </section>
    );
} 