
import { motion } from 'framer-motion';
import Image from 'next/image';

export function SaveTheDate() {
    return (
        <section className="relative bg-[#EBEBEB]">
            {/* Content Container */}
            <div className="relative min-h-screen py-32 md:py-32 flex flex-col items-center justify-center px-4">
                {/* Decorative leaves - left */}
                <div className="absolute left-8 top-[10%] -z-1 hidden md:block">
                    <Image
                        src="/leaves.png"
                        alt="Decorative leaves"
                        width={280}
                        height={80}
                    />
                </div>
                {/* Main Text */}
                <motion.h1
                    initial={{ opacity: 0, y: 20 }}
                    animate={{ opacity: 1, y: 0 }}
                    transition={{ duration: 0.8 }}
                    className="text-center md:text-left text-coral font-script text-4xl md:text-5xl mb-12"
                >
                    We can&apos;t wait to see you there!
                </motion.h1>
                {/* Decorative leaves - right */}
                <div className="absolute right-8 top-[10%] -z-1 scale-x-[-1] hidden md:block">
                    <Image
                        src="/leaves.png"
                        alt="Decorative leaves"
                        width={320}
                        height={80}
                    />
                </div>

                {/* Save the Date Section */}
                <motion.div
                    initial={{ opacity: 0 }}
                    animate={{ opacity: 1 }}
                    transition={{ delay: 0.3, duration: 0.8 }}
                    className="text-center space-y-8"
                >
                    <h2 className="text-[#222222] xl:text-2xl 2xl:text-3xl font-normal">
                        SAVE THE DATE
                    </h2>
                    {/* Decorative leaves - left */}
                    <div className="absolute -left-[20px] top-1/2 -translate-y-1/2 -z-10">
                        <Image
                            src="/leaves.png"
                            alt="Decorative leaves"
                            width={340}
                            height={80}
                        />
                    </div>

                    {/* Details Grid */}
                    <div className="flex items-center justify-center space-x-2 sm:space-x-4 md:space-x-8 xl:text-2xl 2xl:text-3xl font-light">
                        <div className="text-center">
                            <p>Lekki</p>
                            <p>Lagos</p>
                        </div>
                        <div className="h-6 w-px bg-[#222222]" />
                        <div className="text-center">
                            <p>April 25</p>
                            <p>2025</p>
                        </div>
                        <div className="h-6 w-px bg-[#222222]" />
                        <div className="text-center">
                            <p>Joining</p>
                            <p>12 Noon</p>
                        </div>
                        <div className="h-6 w-px bg-[#222222]" />
                        <div className="text-center">
                            <p>Reception</p>
                            <p>3pm</p>
                        </div>
                    </div>

                    {/* Decorative leaves - right */}
                    <div className="absolute -right-[20px] top-1/2 -translate-y-1/2 -z-10 transform scale-x-[-1]">
                        <Image
                            src="/leaves.png"
                            alt="Decorative leaves"
                            width={340}
                            height={80}
                        />
                    </div>

                    {/* RSVP Button */}
                    {/* <button className="btn-outline-dark mt-8" onClick={() => window.location.href = '#rsvp'}>
                        RSVP
                    </button> */}
                </motion.div>

                <div className="border-b border-[#454545]/40 w-2/3 mx-auto self-center my-10"></div>


                <motion.div
                    initial={{ opacity: 0, y: 20 }}
                    whileInView={{ opacity: 1, y: 0 }}
                    transition={{ duration: 0.8 }}
                    className="max-w-6xl mx-auto text-center space-y-1"
                >

                    <h2 className="text-coral font-script text-2xl md:text-3xl">Follow Our Journey</h2>

                    <div className="flex flex-col items-center gap-4">
                        <p className="font-light xl:text-2xl 2xl:text-3xl leading-8 max-w-xl">
                            Join us on Instagram as we share more moments and updates about our journey to forever.
                        </p>
                        <a
                            href="https://www.instagram.com/loveisabc_"
                            target="_blank"
                            rel="noopener noreferrer"
                            className="inline-flex items-center gap-2 p-0 uppercase font-normal hover:text-coral text-sm"
                        >
                            <svg
                                className="w-5 h-5"
                                fill="currentColor"
                                viewBox="0 0 24 24"
                            >
                                <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z" />
                            </svg>
                            @loveisabc_
                        </a>
                    </div>
                </motion.div>

                {/* Copyright */}
                <div className="absolute bottom-8 text-sm text-[#222222]/60">
                    Copyright 2025 | LoveIsABC | All rights reserved
                </div>
            </div>
        </section>
    );
}
