'use client';

import Image from "next/image";
import HeroSlider from "./components/HeroSlider";
import CoupleIntro from "./components/CoupleIntro";
import WeddingParty from "./components/WeddingParty";
import OurStories from "./components/OurStories";
import EngagementStory from "./components/EngagementStory";
// import RsvpForm from "./components/RsvpForm";
import Gifts from "./components/Gifts";
import Gallery from "./components/Gallery";
import RecentBlog from "./components/RecentBlog";
import { SaveTheDate } from "./components/SaveTheDate";
import Navbar from "./components/Navbar";


export default function Home() {

  return (
    <main className="min-h-screen relative overflow-x-hidden ">
      {/* Hero Section with Slider */}
      <section className="relative h-screen" id="home">
        <HeroSlider />
      </section>

      {/* Navigation */}
      <Navbar />

      {/* Couple Intro Section */}
      <section id="couple" className="relative">
        <CoupleIntro />
      </section>

      {/* Party Section */}
      <section className="bg-[#EBEBEB] md:pt-40 md:pb-20">
        <WeddingParty />
      </section>

      <section id="story" className="relative">
        <OurStories />

        {/* full width image */}
        <div className="relative w-full md:h-[500px] 2xl:h-[700px]">
          <Image src="/slider/6.jpg" alt="Couple Photo" fill className="object-cover md:object-[50%_41%]" style={{ position: 'absolute', top: 0, left: 0, width: '100%', height: '100%' }} />
        </div>

        {/* Add Engagement Story Section */}
        <EngagementStory />
      </section>

      {/* <section id="rsvp" className="relative bg-[#F7F7F7]">
        <RsvpForm />
      </section> */}

      {/* Add the Gifts section */}
      <section id="gift" className="relative">
        <Gifts />
      </section>

      {/* Add the Gallery section */}
      <Gallery />

      {/* Add the Recent Blog section */}
      <RecentBlog />

      {/* Add the Save The Date section */}
      <SaveTheDate />
    </main>
  );
}
